/*
 * Decompiled with CFR 0.152.
 */
package com.tp_link.eap.web.monitor.globalsetting;

import com.tp_link.eap.domain.global.OperationResult;
import com.tp_link.eap.domain.globalsetting.TimeSetting;
import com.tp_link.eap.domain.globalsetting.bean.Month;
import com.tp_link.eap.domain.globalsetting.bean.RecurringTime;
import com.tp_link.eap.domain.globalsetting.bean.WeekDay;
import com.tp_link.eap.domain.globalsetting.bean.WeekNum;
import com.tp_link.eap.monitor.globalsetting.a.a;
import com.tp_link.eap.monitor.globalsetting.service.d;
import com.tp_link.eap.util.e;
import com.tp_link.eap.util.p.c;
import com.tp_link.eap.web.monitor.globalsetting.pageinfo.TimeSettingInfo;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/globalsetting"})
public class TimeSettingController {
    @Autowired
    private d a;

    @RequestMapping(value={"getGmt"}, method={RequestMethod.POST})
    @ResponseBody
    public OperationResult getGmt(TimeSetting entry) {
        if (entry == null) {
            return e.aX;
        }
        long l2 = 0L;
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(entry.getNtpServerI());
        arrayList.add(entry.getNtpServerII());
        for (int k = 0; k < 2; ++k) {
            try {
                if (arrayList.get(k) == null || arrayList.get(k) == "") continue;
                l2 = com.tp_link.eap.monitor.globalsetting.a.a.a((String)((String)arrayList.get(k)));
                return new OperationResult(true, null, (Object)l2);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new OperationResult(false, "Unable to contract with ntp server.");
    }

    @RequestMapping(value={"saveTimeSetting"}, method={RequestMethod.POST})
    @ResponseBody
    public OperationResult saveTimeSetting(@Valid TimeSettingInfo entry, BindingResult br) {
        if (br.getAllErrors() != null && !br.getAllErrors().isEmpty()) {
            return new OperationResult(false, c.a((List)br.getAllErrors()));
        }
        TimeSetting timeSetting = this.a.getTimeSetting();
        if (timeSetting == null) {
            timeSetting = new TimeSetting();
        }
        String string = entry.getDate() + " " + entry.getTimeH() + ":" + entry.getTimeM() + ":" + entry.getTimeS();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        simpleDateFormat.setLenient(false);
        try {
            Date date = simpleDateFormat.parse(string);
            timeSetting.setDateTime(date);
            timeSetting.setNtpServerI(entry.getNtpServerI());
            timeSetting.setNtpServerII(entry.getNtpServerII());
            timeSetting.setTimeZone(entry.getTimeZone());
            return this.a.saveTimeSetting(timeSetting, 0, true);
        }
        catch (ParseException parseException) {
            return new OperationResult(false, "Format of Date/Time is illegal.");
        }
    }

    @RequestMapping(value={"getTimeSetting"}, method={RequestMethod.GET})
    @ResponseBody
    public TimeSettingInfo getTimeSetting() {
        RecurringTime recurringTime;
        String string;
        TimeSetting timeSetting = this.a.getTimeSetting();
        if (timeSetting == null) {
            return null;
        }
        TimeSettingInfo timeSettingInfo = new TimeSettingInfo();
        timeSettingInfo.setNtpServerI(timeSetting.getNtpServerI());
        timeSettingInfo.setNtpServerII(timeSetting.getNtpServerII());
        timeSettingInfo.setTimeZone(timeSetting.getTimeZone());
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy/MM/dd HH mm ss");
        Date date = timeSetting.getDateTime();
        if (date != null) {
            string = simpleDateFormat.format(date);
            recurringTime = string.split(" ");
            timeSettingInfo.setDate(recurringTime[0]);
            timeSettingInfo.setTimeH(Integer.parseInt(recurringTime[1]));
            timeSettingInfo.setTimeM(Integer.parseInt(recurringTime[2]));
            timeSettingInfo.setTimeS(Integer.parseInt((String)recurringTime[3]));
        }
        timeSettingInfo.setDayLightSavingEnable(timeSetting.getDayLightSavingEnable());
        timeSettingInfo.setPredefineCountry(timeSetting.getPredefineCountry());
        timeSettingInfo.setTimeOffsetRec(timeSetting.getTimeOffsetRec());
        timeSettingInfo.setTimeOffsetDate(timeSetting.getTimeOffsetDate());
        timeSettingInfo.setMode(timeSetting.getMode());
        string = timeSetting.getRecurringStart();
        recurringTime = timeSetting.getRecurringEnd();
        if (recurringTime != null && string != null) {
            timeSettingInfo.setCountRecS(string.getWeekNum().toString());
            timeSettingInfo.setMonthRecS(string.getMonth().toString());
            timeSettingInfo.setWeekRecS(string.getWeekDay().toString());
            timeSettingInfo.setHourRecS(string.getHour());
            timeSettingInfo.setMinRecS(string.getMin());
            timeSettingInfo.setCountRecE(recurringTime.getWeekNum().toString());
            timeSettingInfo.setMonthRecE(recurringTime.getMonth().toString());
            timeSettingInfo.setWeekRecE(recurringTime.getWeekDay().toString());
            timeSettingInfo.setHourRecE(recurringTime.getHour());
            timeSettingInfo.setMinRecE(recurringTime.getMin());
        }
        List<String> list = this.a(timeSetting.getStart());
        List<String> list2 = this.a(timeSetting.getEnd());
        if (list.size() == 5 && list2.size() == 5) {
            timeSettingInfo.setYearDateS(list.get(0));
            timeSettingInfo.setMonthDateS(list.get(1));
            timeSettingInfo.setDayDateS(list.get(2));
            timeSettingInfo.setHourDateS(list.get(3));
            timeSettingInfo.setMinDateS(list.get(4));
            timeSettingInfo.setYearDateE(list2.get(0));
            timeSettingInfo.setMonthDateE(list2.get(1));
            timeSettingInfo.setDayDateE(list2.get(2));
            timeSettingInfo.setHourDateE(list2.get(3));
            timeSettingInfo.setMinDateE(list2.get(4));
        }
        return timeSettingInfo;
    }

    @RequestMapping(value={"setDaylight"}, method={RequestMethod.POST})
    @ResponseBody
    public OperationResult setDaylight(@Valid TimeSettingInfo entry) {
        if (entry == null) {
            return e.aX;
        }
        TimeSetting timeSetting = this.a.getTimeSetting();
        if (timeSetting == null) {
            timeSetting = new TimeSetting();
        }
        timeSetting.setDayLightSavingEnable(entry.getDayLightSavingEnable());
        if (entry.getDayLightSavingEnable().booleanValue()) {
            Object object;
            Object object2;
            timeSetting.setMode(entry.getMode());
            if (entry.getMode().equals("predefined")) {
                timeSetting.setPredefineCountry(entry.getPredefineCountry());
            }
            if (entry.getMode().equals("recurring")) {
                timeSetting.setTimeOffsetRec(entry.getTimeOffsetRec());
                object2 = this.a(entry.getCountRecS(), entry.getWeekRecS(), entry.getMonthRecS(), entry.getHourRecS(), entry.getMinRecS());
                timeSetting.setRecurringStart(object2);
                object = this.a(entry.getCountRecE(), entry.getWeekRecE(), entry.getMonthRecE(), entry.getHourRecE(), entry.getMinRecE());
                timeSetting.setRecurringEnd((RecurringTime)object);
            }
            if (entry.getMode().equals("date")) {
                timeSetting.setTimeOffsetDate(entry.getTimeOffsetDate());
                object2 = this.a(entry.getYearDateS(), entry.getMonthDateS(), entry.getDayDateS(), entry.getHourDateS(), entry.getMinDateS());
                object = this.a(entry.getYearDateE(), entry.getMonthDateE(), entry.getDayDateE(), entry.getHourDateE(), entry.getMinDateE());
                if (object2 == null) {
                    return new OperationResult(false, "Start date is illegal.");
                }
                if (object == null) {
                    return new OperationResult(false, "End date is illegal.");
                }
                if (((Date)object).before((Date)object2)) {
                    return new OperationResult(false, "End time should be later than start time.");
                }
                timeSetting.setStart((Date)object2);
                timeSetting.setEnd((Date)object);
            }
        }
        return this.a.saveTimeSetting(timeSetting, 1, true);
    }

    private RecurringTime a(String string, String string2, String string3, Integer n, Integer n2) {
        RecurringTime recurringTime = new RecurringTime();
        recurringTime.setHour(n);
        recurringTime.setMin(n2);
        recurringTime.setMonth(Month.valueOf((String)string3));
        recurringTime.setWeekNum(WeekNum.valueOf((String)string));
        recurringTime.setWeekDay(WeekDay.valueOf((String)string2));
        return recurringTime;
    }

    private Date a(String string, String string2, String string3, String string4, String string5) {
        Date date;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        simpleDateFormat.setLenient(false);
        String string6 = "" + string + "-" + string2 + "-" + string3 + " " + string4 + ":" + string5;
        try {
            date = simpleDateFormat.parse(string6);
        }
        catch (ParseException parseException) {
            return null;
        }
        return date;
    }

    private List<String> a(Date date) {
        if (date == null) {
            return new ArrayList<String>();
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        String string = simpleDateFormat.format(date);
        String[] stringArray = string.split("[- :]");
        arrayList.addAll(Arrays.asList(stringArray));
        return arrayList;
    }
}

